/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY                          *
 *                                                                            *
 * This program is free software; you can redistribute it and/or modify       *
 * it under the terms of the GNU General Public Liense as published by        *
 * the Free Software Foundation, either version 2 of the License, or (at      * 
 * your option) any later version.                                            *
 *                                                                            *
 * The ITX package is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY, without even the implied warranty of MERCHANTABILITY *
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License   *
 * for more details.                                                          * 
 *                                                                            *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.                                                   *
 *                                                                            * 
 * Contact information:                                                       *
 * Donna Bergmark                                                             *
 * 484 Rhodes Hall                                                            *
 * Cornell University                                                         *
 * Ithaca, NY 14853-3801                                                      *
 * bergmark@cs.cornell.edu                                                    *
 ******************************************************************************/


package cnrg.itx.datax.client;

import cnrg.itx.datax.*;
import cnrg.itx.datax.devices.*;
import java.io.*;
import java.net.*;

/**
 * This class tests audio streaming over the network.  This sample routine uses a StreamSource,
 * NetworkDestination, NetworkSource, and SpeakerDestination to play an audio file over the
 * network.  Note that in creating the various destinations and sources, the remote
 * source/destination sample size MUST equal the local source/destination sample size.
 * <p>
 * Usage: jview cnrg.itx.datax.devices.NetworkTest [audio file][seconds to play]
 * 
 * @author Jason Howes
 * @version 1.1, 3/6/1999
 * @see cnrg.itx.datax.Channel
 * @see cnrg.itx.datax.devices.StreamSource
 * @see cnrg.itx.datax.devices.NetworkDestination
 * @see cnrg.itx.datax.devices.NetworkSource
 * @see cnrg.itx.datax.devices.SpeakerDestination
 */
class NetworkTest
{	
	public static int NUM_ARGS	= 2;
		
	public static void main(String []args)
	{	
		try
		{	
			// Check command line args
			if (args.length != NetworkTest.NUM_ARGS)
			{
				System.out.println("NetworkTest : [audio file][seconds to play]");
				System.exit(0);
			}
			
			// NOTE: The local NetworkSource/Destination and remote Source/NetworkDestination sample
			// sizes MUST be the SAME!!!			
			
			// Output channel, source, and destination
			Channel outChannel = new Channel();
			StreamSource outSource = new StreamSource(new FileInputStream(args[0]), outChannel, 100);
			NetworkDestination outDest = new NetworkDestination();
			
			// Input channel, source, and destination
			Channel inChannel = new Channel();
			NetworkSource inSource = new NetworkSource(inChannel,
		   						 SpeakerDestination.SAMPLE_SIZE);
			SpeakerDestination inDest = new SpeakerDestination();
					
			// Set output channel
			outChannel.setSource(outSource);
			outChannel.addDestination(outDest);
			
			// Set input channel
			inChannel.setSource(inSource);
			inChannel.addDestination(inDest);

			// get the properties collection from the input Channel and set on output channel
			PropertiesCollection pc = inChannel.getProperties();
			outChannel.setPeerProperties(pc);
			
			// Start source and destination
			outChannel.open();
			inChannel.open();
			
			// Let the audio file play...
			System.out.println("Playing " + args[0] + " for " + args[1] + " seconds...");
			Thread.sleep(Integer.parseInt(args[1])*1000);
			System.out.println("Done.");
			
			inChannel.close();
			outChannel.close();
		}
		catch (Exception e)
		{
			System.out.println(e.getMessage());
		}
	}
}
